


varying vec4 color;
varying float NdotL;

flat varying vec3 torch;
varying vec3 viewVector;
varying vec2 lmtexcoord;


float gbf(in vec3 eyePlayerPos, in float far)
{

    return smoothstep(0, length(eyePlayerPos.xz) * 1.1, far);
}
/* DRAWBUFFERS:1*/
void main()
{
    vec3 p3 = toWorldSpace(viewVector);

    vec4 color = texture(texture, lmtexcoord.xy) * color;
    color.rgb = toLinear(color.rgb) * (sunLight * 0.26 * max(NdotL, 0.5) + (atmosphereUp * 8.0) + torch);
    color.a *= (gbf(p3, far)) * 0.6;
    gl_FragData[0] = color;
}
